package ru.yandex.webmaster3.openapi.codegen;

import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.ClientOpts;
import io.swagger.codegen.CodegenConstants;
import io.swagger.codegen.DefaultGenerator;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import org.apache.commons.cli.*;

/**
 * Created by Oleg Bazdyrev on 11/12/2019.
 */
public class JavaCodegenRunner {

    public static void main(String[] args) {
        Options options = new Options();
        options.addOption("h", "help", false, "shows this message");
        options.addOption("o", "output", true, "where to write the generated files");
        options.addOption("i", "input-spec", true, "location of the swagger spec, as URL or file");
        options.addOption("t", "template-dir", true, "folder containing the template files");
        options.addOption("ap", CodegenConstants.API_PACKAGE, true, CodegenConstants.API_PACKAGE_DESC);
        options.addOption("mp", CodegenConstants.MODEL_PACKAGE, true, CodegenConstants.MODEL_PACKAGE_DESC);
        options.addOption("mnp", CodegenConstants.MODEL_NAME_PREFIX, true, CodegenConstants.MODEL_NAME_PREFIX_DESC);

        ClientOptInput clientOptInput = new ClientOptInput();
        var codegen = new WebmasterOpenAPICodegen();
        clientOptInput.setConfig(codegen);
        ClientOpts clientOpts = new ClientOpts();
        Swagger swagger = null;

        CommandLine cmd;
        try {
            CommandLineParser parser = new BasicParser();
            cmd = parser.parse(options, args);
            if (cmd.hasOption("o")) {
                clientOptInput.getConfig().setOutputDir(cmd.getOptionValue("o"));
            }
            if (cmd.hasOption("i")) {
                swagger = new SwaggerParser().read(cmd.getOptionValue("i"));
            }
            if (cmd.hasOption("ap")) {
                clientOptInput.getConfig().additionalProperties().put(CodegenConstants.API_PACKAGE, cmd.getOptionValue("ap"));
            }
            if (cmd.hasOption("mp")) {
                clientOptInput.getConfig().additionalProperties().put(CodegenConstants.MODEL_PACKAGE, cmd.getOptionValue("mp"));
            }
            if (cmd.hasOption("mnp")) {
                clientOptInput.getConfig().additionalProperties().put(CodegenConstants.MODEL_NAME_PREFIX, cmd.getOptionValue("mnp"));
            }
            if (cmd.hasOption("t")) {
                clientOpts.getProperties().put(CodegenConstants.TEMPLATE_DIR, String.valueOf(cmd.getOptionValue("t")));
            }
            clientOptInput.getConfig().additionalProperties().put(CodegenConstants.LIBRARY, "apache-http");
            clientOptInput.getConfig().additionalProperties().put("dateLibrary", "joda");
            clientOptInput.getConfig().additionalProperties().put(CodegenConstants.INVOKER_PACKAGE, "ru.yandex.webmaster3.core.openapi.internal");
        } catch (Exception e) {
            System.out.println(e.getMessage());
            usage(options);
            System.exit(1);
        }

        try {
            System.setProperty(CodegenConstants.APIS, "");
            System.setProperty(CodegenConstants.MODELS, "");
            clientOptInput.opts(clientOpts).swagger(swagger);
            new DefaultGenerator().opts(clientOptInput).generate();
        } catch (Exception e) {
            usage(options);
            System.exit(1);
        }
    }

    static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("JavaCodegenRunner", options);
    }

}
