#!/bin/bash

# PEERDIR курильщика для внешних протобуфов

SVN_URL="svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia"

UPDATED_DIRS=()
DOWNLOADED_PROTOS=()
COPIED_PROTOS=()

is_dir_updated() {
    for d in ${UPDATED_DIRS[@]}; do
        if [[ "${d}" = "$1" ]]; then
            return 1
        fi
    done

    return 0
}

is_proto_downloaded() {
    for d in ${DOWNLOADED_PROTOS[@]}; do
        if [[ "${d}" = "$1" ]]; then
            return 1
        fi
    done

    return 0
}

download_proto() {
    PROTO_FILE_ARCADIA_PATH="$1"

    PROTO_FILE_DIR=`dirname ${PROTO_FILE_ARCADIA_PATH}`
    PROTO_FILE_DIR_LOCAL_PATH="${PROTO_DST_DOWNLOAD_DIR}/${PROTO_FILE_DIR}"
    PROTO_FILE_LOCAL_PATH="${PROTO_DST_DOWNLOAD_DIR}/${PROTO_FILE_ARCADIA_PATH}"
    PROTO_FILE_DIR_SVN_URL="${SVN_URL}/${PROTO_FILE_DIR}"

    echo "Downloading ${PROTO_FILE_ARCADIA_PATH}"
    if [[ "${PROTO_FILE_DIR}" = "google/protobuf" ]]
    then
        return 1
    fi

    is_proto_downloaded ${PROTO_FILE_DIR_LOCAL_PATH}
    if [[ $? -eq 1 ]]
    then
        echo "${PROTO_FILE_ARCADIA_PATH} already downloaded"
        return 1
    else
        DOWNLOADED_PROTOS+=(${PROTO_FILE_ARCADIA_PATH})
    fi

    is_dir_updated ${PROTO_FILE_DIR_LOCAL_PATH}
    if [[ $? -eq 1 ]]
    then
        echo "${PROTO_FILE_DIR_LOCAL_PATH} already updated"
    else
        UPDATED_DIRS+=(${PROTO_FILE_DIR_LOCAL_PATH})
        echo ${PROTO_FILE_DIR_SVN_URL}
        if [[ -d ${PROTO_FILE_DIR_LOCAL_PATH} ]]; then
            if [ -z "$(ls -p ${PROTO_FILE_DIR_LOCAL_PATH} | grep -v '/' )" ]; then
                echo "Removing ${PROTO_FILE_DIR_LOCAL_PATH}"
                rm -rf ${PROTO_FILE_DIR_LOCAL_PATH}
                #echo "svn co ${PROTO_FILE_DIR_SVN_URL} ${PROTO_FILE_DIR_LOCAL_PATH}"
                svn co ${PROTO_FILE_DIR_SVN_URL} ${PROTO_FILE_DIR_LOCAL_PATH}
            else
                #echo "svn up ${PROTO_FILE_DIR_LOCAL_PATH}"
                svn up ${PROTO_FILE_DIR_LOCAL_PATH}
            fi
        else
            # echo "svn co ${PROTO_FILE_DIR_SVN_URL} ${PROTO_FILE_DIR_LOCAL_PATH}"
            svn co ${PROTO_FILE_DIR_SVN_URL} ${PROTO_FILE_DIR_LOCAL_PATH}
        fi
    fi

    PROTO_IMPORTS=( $( grep -o "import .*"  ${PROTO_FILE_LOCAL_PATH} | grep -Eo '".*"' | sed -e 's/^"//' -e 's/"$//' ) )
    for p in ${PROTO_IMPORTS[@]}; do
        download_proto ${p}
    done

    return 0
}

is_proto_copied() {
    for d in ${COPIED_PROTOS[@]}; do
        if [[ "${d}" = "$1" ]]; then
            return 1
        fi
    done

    return 0
}

copy_proto() {
    PROTO_FILE_ARCADIA_PATH="$1"

    PROTO_FILE_DIR=`dirname ${PROTO_FILE_ARCADIA_PATH}`
    PROTO_FILE_DIR_LOCAL_PATH="${PROTO_DST_DIR}/${PROTO_FILE_DIR}"
    PROTO_FILE_LOCAL_PATH="${PROTO_DST_DIR}/${PROTO_FILE_ARCADIA_PATH}"
    PROTO_FILE_DIR_SVN_URL="${SVN_URL}/${PROTO_FILE_DIR}"

    if [[ "${PROTO_FILE_DIR}" = "google/protobuf" ]]
    then
        return 1
    fi

    echo "Copying ${PROTO_FILE_ARCADIA_PATH}"
    is_proto_copied ${PROTO_FILE_ARCADIA_PATH}
    if [[ $? -eq 1 ]]
    then
        echo "${PROTO_FILE_ARCADIA_PATH} already copied"
        return 1
    else
        COPIED_PROTOS+=(${PROTO_FILE_ARCADIA_PATH})
    fi

    mkdir -p ${PROTO_FILE_DIR_LOCAL_PATH}
    cp "${PROTO_DST_DOWNLOAD_DIR}/${PROTO_FILE_ARCADIA_PATH}" ${PROTO_FILE_DIR_LOCAL_PATH}


    PROTO_IMPORTS=( $( grep -o "import .*"  ${PROTO_FILE_LOCAL_PATH} | grep -Eo '".*"' | sed -e 's/^"//' -e 's/"$//' ) )
    for p in ${PROTO_IMPORTS[@]}; do
        copy_proto ${p}
    done

    return 0
}

PROTO_DST_DIR=$1
mkdir -p ${PROTO_DST_DIR}
shift

PROTO_DST_DOWNLOAD_DIR="${PROTO_DST_DIR}.tmp"
mkdir -p ${PROTO_DST_DOWNLOAD_DIR}

# download protos from command line
while test ${#} -gt 0
do
  echo $1
  download_proto $1
  copy_proto $1
  shift
done

# TODO: remove these hacks (by starting using ya.make)
echo "Applying proto files workarounds..."
echo "" >> "${PROTO_DST_DIR}/mapreduce/yt/interface/protos/extension.proto"
echo 'option java_package = "ru.yandex.mapreduce.yt.protos";' >> "${PROTO_DST_DIR}/mapreduce/yt/interface/protos/extension.proto"

echo "" >> "${PROTO_DST_DIR}/yweb/protos/outlinks/links.proto"
echo 'option java_package = "ru.yandex.yweb.protos.outlinks";' >> "${PROTO_DST_DIR}/yweb/protos/outlinks/links.proto"

echo "" >> "${PROTO_DST_DIR}/yweb/protos/links.proto"
echo 'option java_package = "ru.yandex.yweb.protos";' >> "${PROTO_DST_DIR}/yweb/protos/links.proto"

echo "" >> "${PROTO_DST_DIR}/yweb/robot/erf/protos/regerfinfos.proto"
echo 'option java_package = "ru.yandex.yweb.robot.erf.protos";' >> "${PROTO_DST_DIR}/yweb/robot/erf/protos/regerfinfos.proto"

#
mv "${PROTO_DST_DIR}/yweb/robot/js/rotor/proto/events.ev" "${PROTO_DST_DIR}/yweb/robot/js/rotor/proto/events.ev.proto"
sed -E 's|^import "yweb/robot/js/rotor/proto/events.ev"|import "yweb/robot/js/rotor/proto/events.ev.proto"|' ${PROTO_DST_DIR}/yweb/robot/js/rotor/proto/trace.proto > ${PROTO_DST_DIR}/yweb/robot/js/rotor/proto/trace.proto.new
mv ${PROTO_DST_DIR}/yweb/robot/js/rotor/proto/trace.proto.new ${PROTO_DST_DIR}/yweb/robot/js/rotor/proto/trace.proto

mv "${PROTO_DST_DIR}/robot/jupiter/protos/compatibility/web_factors.proto" "${PROTO_DST_DIR}/robot/jupiter/protos/compatibility/web_factors_compat.proto"
grep -rl 'compatibility/web_factors.proto' ${PROTO_DST_DIR} | xargs sed -i 's/compatibility\/web_factors.proto/compatibility\/web_factors_compat.proto/g'
