#!/usr/bin/env /usr/local/Cellar/python/2.7.10_2/bin/python

from webmaster3.cass import Cass, Keyspaces
from webmaster3.task import Task
import query_group_cassandra_pb2 as qgc
import time

def get_proto(val):
    filters = qgc.CassandraQueryFilters()
    filter = filters.filters.add()
    filter.indicator = 13 #AVERAGE_SHOW_POSITION
    filter.operation = 2 #LESS_EQUAL
    filter.numberValue = val
    b = filters.SerializeToString()
    return Cass.to_blob(b)

b3 = get_proto(3)
b10 = get_proto(10)
b50 = get_proto(50)

def run(cluster, nThreads, nThread):
    session = Cass.cluster(cluster).connect()
    session.set_keyspace(Keyspaces.WEBMASTER3_SEARCH_QUERIES)
    rows = session.execute("SELECT * FROM query_group")

    N = 12160000
    i = 0
    ct = time.time()

    for r in rows:
        i += 1
        if i%1000 == 0:
            dt = time.time() - ct
            ct = ct + dt
            est = (N - i) / 1000 * dt
            print i, est

        if i%nThreads == nThread:
            b = None
            if not r.query_filter:
                if r.group_name == "Top 3": b = b3
                elif r.group_name == "Top 10": b = b10
                elif r.group_name == "Top 50": b = b50

                if b:
                    q = "UPDATE query_group SET query_filter = 0x%s WHERE host_id = '%s' AND query_group_id = %s" % (b, r.host_id, r.query_group_id)
                    session.execute(q)    

Task.run_mt(run, "prod", 10)