
from webmaster3.cass import Cass, Keyspaces
from webmaster3.task import Task
import sets

def cass_value(v):
    if not v:
        return "null"
    return v

def cass_string(v):
    if not v:
        return "null"
    return "'" + v + "'"

def cass_date(v):
    if not v:
        return "null"
    return "'" + str(v).split('.')[0]+"+0300'"

def run(cluster):
    session = Cass.cluster(cluster).connect()
    session.set_keyspace(Keyspaces.WEBMASTER3)
    rows = session.execute("SELECT * FROM main_mirror_requests_n")
    i = 0
    for r in rows:
        #if i < 5000:
        #    i += 1
        #    continue

        q = "INSERT INTO main_mirror_requests (host_id, user_id, request_id, state, create_date, update_date, desired_main_host_id, old_main_host_id, attempt_count, service_response) "
        q += "VALUES(%s, %s, %s, %s, %s, %s, %s, %s, 0, %s)"

        q = q % (cass_string(r.host_id), cass_value(r.user_id), cass_value(r.request_id), cass_value(r.state), cass_date(r.create_date), cass_date(r.update_date), cass_string(r.desired_main_host_id), cass_string(r.old_main_host_id), cass_string(r.service_response))
        session.execute(q)

        print i
        i += 1


Task.run(run, "prod")