#!/usr/bin/env /usr/local/Cellar/python/2.7.10_2/bin/python

from webmaster3.cass import Cass, Keyspaces
from webmaster3.task import Task
import urllib2, uuid

def cass_value(v):
    if not v:
        return "null"
    return v

def cass_string(v):
    if not v:
        return "null"
    return "'" + v + "'"

def cass_date(v):
    if not v:
        return "null"
    return "'" + str(v).split('.')[0]+"+0300'"


def run(cluster):
    session = Cass.cluster(cluster).connect()
    session.set_keyspace(Keyspaces.WEBMASTER3)
    rows = session.execute("SELECT * FROM hosts")

    N = 1000

    i = 0
    for r in rows:
        if i >= N:
            break

        print r.host_id

        request_id = str(uuid.uuid1())
        q = "INSERT INTO main_mirror_requests (host_id, user_id, request_id, state, create_date, update_date, desired_main_host_id, old_main_host_id, attempt_count, service_response) "
        q += "VALUES(%s, 0, %s, 0, %s, %s, %s, %s, 0)"

        q = q % (cass_string(r.host_id), request_id, "2016-01-28 18:00:00+0300", "2016-01-28 18:00:00+0300", "http:lenta.ru:80", cass_string(r.host_id))
        #session.execute(q)

        i = i+1

        request = 'http://webmaster.dev.search.yandex.net:55557/task/enqueue.json?taskId=test&taskType=CHANGE_MAIN_MIRROR&taskData={"hostId":"%s","requestId":"%s"}&applicationHostname=test&applicationName=test&applicationVersion=1' % (r.host_id, request_id)
        response = urllib2.urlopen(request).read()
        print response

Task.run(run, "test")