from webmaster3.cass import Cass, Keyspaces
from webmaster3.task import Task
from cassandra import ConsistencyLevel
import sets

def cass_value(v):
    if not v:
        return "null"
    return v

def cass_string(v):
    if not v:
        return "null"
    return "'" + v + "'"

def cass_date(v):
    if not v:
        return "null"
    return "'" + str(v).split('.')[0]+"+0300'"

def run(cluster):
    session = Cass.cluster(cluster).connect()
    session.default_consistency_level = ConsistencyLevel.LOCAL_ONE
    session.default_timeout = 3600
    session.set_keyspace(Keyspaces.WEBMASTER3_INTERNAL)
    rows = session.execute("SELECT host_id, experiment_type FROM abt_host_experiment")
    i = 0
    for r in rows:
        if r.experiment_type != 'SURVEY':
            continue

        q = "delete from abt_host_experiment where host_id=%s and experiment_type=%s"

        q = q % (cass_string(r.host_id), cass_string(r.experiment_type))
        session.execute(q)


Task.run(run, "prod")
