import csv
import uuid
import gzip
import datetime
from cassandra import util

from webmaster3.cass import Cass, Keyspaces
from webmaster3.task import Task

WRITER = None
SESSION = None

MAX_AGE_IN_DAYS = 14

def run(cluster):
    global WRITER, SESSION

    SESSION = Cass.cluster(cluster).connect()
    SESSION.set_keyspace(Keyspaces.WEBMASTER3)

    from os.path import expanduser
    home_path = expanduser("~")

    with open(home_path + '/latest_host_display_name_requests.csv', "w") as f:
        WRITER = csv.writer(f, delimiter=';', quoting=csv.QUOTE_ALL)
        collect_requests()

    print "Done."


def collect_requests():
    all_hosts_it = SESSION.execute("SELECT host_id FROM host_display_name_moderation")
    all_hosts = set()
    for h in all_hosts_it:
        all_hosts.add(h.host_id)

    count = 0
    for host_id in all_hosts:
        if count % 1000 == 0:
            print 'Processed: %s' % count

        req_list = list(SESSION.execute("select * from host_display_name_moderation where host_id = '%s' ORDER BY request_id DESC limit 1" % host_id))
        if not req_list:
            count += 1
            continue

        req = req_list[0]
        created_date = util.datetime_from_uuid1(req.request_id)
        now = datetime.datetime.now()
        delta_days = (now - created_date).days
        if delta_days > MAX_AGE_IN_DAYS:
            count += 1
            continue

        state = req.state
        if state == 1:
            state = 'IN_PROGRESS'
        elif state == 2:
            state = 'ACCEPTED'
        elif state == 3:
            state = 'REFUSED'
        elif state == 5:
            state = 'CANCELLED'
        else:
            state = 'UNKNOWN'

        WRITER.writerow((req.host_id, req.request_id, state, req.display_name, created_date, req.modification_date, req.assessor_id, delta_days))
        count += 1

Task.run(run, "prod")
