from cassandra.cluster import Cluster
from cassandra.io.libevreactor import LibevConnection
from cassandra.policies import RoundRobinPolicy, TokenAwarePolicy
from cassandra.cluster import ExecutionProfile


nodes = {
        "dev": [
            "wmc-cs-01.i-folb.fog.yandex.net",
            "wmc-cs-02.i-folb.fog.yandex.net",
            "wmc-cs-03.i-folb.fog.yandex.net",
            "wmc-cs-04.i-folb.fog.yandex.net",
            "wmc-cs-05.i-folb.fog.yandex.net",
            "wmc-cs-06.i-folb.fog.yandex.net"
        ],
        "test": [
             "wmctest-csdb02g.search.yandex.net",
             "wmctest-csdb03g.search.yandex.net",
             "wmctest-csdb01e.search.yandex.net",
             "wmctest-csdb04e.search.yandex.net"
        ],
        "prod": [
             "wmc-csdb11-iva.search.yandex.net",
             "wmc-csdb12-iva.search.yandex.net",
             "wmc-csdb13-iva.search.yandex.net",
             "wmc-csdb14-iva.search.yandex.net",
             "wmc-csdb15-iva.search.yandex.net",
             "wmc-csdb11-sas.search.yandex.net",
             "wmc-csdb12-sas.search.yandex.net",
             "wmc-csdb13-sas.search.yandex.net",
             "wmc-csdb14-sas.search.yandex.net",
             "wmc-csdb15-sas.search.yandex.net",
             "wmc-csdb11-myt.search.yandex.net",
             "wmc-csdb12-myt.search.yandex.net",
             "wmc-csdb13-myt.search.yandex.net",
             "wmc-csdb14-myt.search.yandex.net",
             "wmc-csdb15-myt.search.yandex.net"
        ]
}


class Keyspaces:
    WEBMASTER3 = "webmaster3"
    WEBMASTER3_INTERNAL = "webmaster3_internal"
    WEBMASTER3_SEARCH_QUERIES = "webmaster3_search_queries"
    WEBMASTER3_HISTORY = "webmaster3_history"


class Cass:
    @staticmethod
    def cluster(cluster_name):
        if cluster_name not in nodes:
            raise Exception("Error: unknown cluster, available clusters: " + ", ".join(nodes.keys()))

        cl = Cluster(nodes[cluster_name])
        cl.protocol_version = 4
        cl.compression = 'snappy'
        cl.load_balancing_policy = TokenAwarePolicy(RoundRobinPolicy())
        cl.connection_class = LibevConnection
        cl.connect_timeout = 3600

        return cl

    @staticmethod
    def to_blob(s):
        return s.encode('hex')
