import unittest
from unittest import TestCase

from base import *

USER_ID = get_user_id()
print "API user id: " + str(USER_ID)

HOST = 'http://24nsk.ru'
HOST_ID = url_to_host_id(HOST)
print "Using host: " + HOST_ID

DATE_FROM = '2016-08-17'
DATE_TO = '2019-07-12'

INTERNAL_LINKS_SAMPLES_PATH = "/user/{user_id}/hosts/{host_id}/links/internal/broken/samples/".format(user_id=USER_ID, host_id=HOST_ID)
INTERNAL_LINKS_HISTORY_PATH = "/user/{user_id}/hosts/{host_id}/links/internal/broken/history/".format(user_id=USER_ID, host_id=HOST_ID)


def get_internal_links_samples(offset=0, limit=10):
    r = SESSION.get(API_URL + INTERNAL_LINKS_SAMPLES_PATH, params={
        'offset': offset,
        'limit': limit,
    })
    c = validate_api_response(r, ['count', 'links'])

    return c


def get_internal_links_history(date_to=DATE_TO, date_from=DATE_FROM):
    r = SESSION.get(API_URL + INTERNAL_LINKS_HISTORY_PATH, params={
        'date_from': date_from,
        'date_to': date_to,
    })
    c = validate_api_response(r, ['indicators'])

    return c['indicators']


class TestLinks(unittest.TestCase):
    def do_test_date_range_filter(self, all_data, data_getter):
        all_data_slice = all_data[1:-2]
        date_from = all_data_slice[0]['date']
        date_to = all_data_slice[-1]['date']
        filtered_data = data_getter(date_from=date_from, date_to=date_to)
        assert filtered_data == all_data_slice

    def do_test_paging(self, all_data, data_getter, total_pages, page_size):
        for offset in range(0, total_pages * page_size, page_size):
            print "Getting page at: " + str(offset)
            pages_data = data_getter(offset=offset, limit=page_size)
            ref_pages_data = all_data[offset:offset + page_size]
            TestCase.assertItemsEqual(self, pages_data, ref_pages_data)

    def test_internal_links_samples(self):
        print "Getting all internal link samples"
        all_samples = get_internal_links_samples(offset=0, limit=100)
        links = all_samples['links']
        TestCase.assertGreater(self, all_samples['count'], 0)
        TestCase.assertEqual(self, len(links), 100)

        total_pages = 3
        page_size = 5
        total_queries = total_pages * page_size

        print "Testing internal link samples paging"
        all_samples = get_internal_links_samples(offset=0, limit=total_queries)
        self.do_test_paging(
            all_samples['links'],
            lambda offset, limit: get_internal_links_samples(offset=offset, limit=limit)['links'],
            total_pages,
            page_size
        )

    def test_internal_link_history(self):
        print "Testing internal link history"
        links_history = get_internal_links_history()
        TestCase.assertIn(self, 'DISALLOWED_BY_USER', links_history)

        print "Testing getting query history for date range..."
        self.do_test_date_range_filter(
            links_history['DISALLOWED_BY_USER'],
            lambda date_from, date_to:
            get_internal_links_history(date_from=date_from, date_to=date_to)['DISALLOWED_BY_USER']
        )


if __name__ == "__main__":
    unittest.main()
