import unittest
from unittest import TestCase

from base import *

DATE_TO = '2019-08-18'
DATE_FROM = '2019-07-18'

USER_ID = get_user_id()
print "API user id: " + str(USER_ID)

HOST = 'http://www.bloknotov.ru'
HOST_ID = url_to_host_id(HOST)
print "Using host: " + HOST_ID

QUERY_HISTORY_PATH_FORMAT = "/user/{user_id}/hosts/{host_id}/search-queries/{query_id}/history/"
POPULAR_QUERIES_LIST_PATH = "/user/{user_id}/hosts/{host_id}/search-queries/popular/".format(user_id=USER_ID, host_id=HOST_ID)
ALL_QUERIES_HISTORY_PATH = "/user/{user_id}/hosts/{host_id}/search-queries/all/history/".format(user_id=USER_ID, host_id=HOST_ID)


def get_popular_queries_list(
        date_from=DATE_FROM,
        date_to=DATE_TO,
        query_indicator=None,
        device_type_indicator='ALL',
        offset=0,
        limit=500):

    if query_indicator is None:
        query_indicator = ['TOTAL_SHOWS']

    r = SESSION.get(API_URL + POPULAR_QUERIES_LIST_PATH, params={
        'date_from': date_from,
        'date_to': date_to,
        'query_indicator': query_indicator,
        'order_by': 'TOTAL_SHOWS',
        'device_type_indicator': device_type_indicator,
        'offset': offset,
        'limit': limit,
    })
    c = validate_api_response(r, ['count', 'queries'])

    return c


def get_query_history_path(query_id):
    return QUERY_HISTORY_PATH_FORMAT.format(user_id=USER_ID, host_id=HOST_ID, query_id=query_id)


def get_query_history(query_id, date_from=DATE_FROM, date_to=DATE_TO, query_indicator=None):
    if query_indicator is None:
        query_indicator = ['TOTAL_SHOWS']

    r = SESSION.get(API_URL + get_query_history_path(query_id), params={
        'date_from': date_from,
        'date_to': date_to,
        'query_indicator': query_indicator
    })
    c = validate_api_response(r, ['indicators'])

    return c['indicators']


def get_all_queries_history(date_from=DATE_FROM, date_to=DATE_TO, query_indicator=None):
    if query_indicator is None:
        query_indicator = ['TOTAL_SHOWS']

    r = SESSION.get(API_URL + ALL_QUERIES_HISTORY_PATH, params={
        'date_from': date_from,
        'date_to': date_to,
        'query_indicator': query_indicator
    })
    c = validate_api_response(r, ['indicators'])

    return c['indicators']


class TestSearchQueries(unittest.TestCase):
    def do_test_date_range_filter(self, all_data, data_getter):
        all_data_slice = all_data[1:-2]
        date_from = all_data_slice[0]['date']
        date_to = all_data_slice[-1]['date']
        filtered_data = data_getter(date_from=date_from, date_to=date_to)
        assert filtered_data == all_data_slice

    def do_test_paging(self, all_data, data_getter, total_pages, page_size):
        for offset in range(0, total_pages * page_size, page_size):
            print "Getting page at: " + str(offset)
            pages_data = data_getter(offset=offset, limit=page_size)
            ref_pages_data = all_data[offset:offset + page_size]
            TestCase.assertItemsEqual(self, pages_data, ref_pages_data)

    def test_popular_queries_list(self):
        print "Testing popular queries"

        print "Getting popular queries"
        all_queries = get_popular_queries_list()
        print "Got " + str(all_queries['count']) + " queries"
        TestCase.assertGreater(self, all_queries['count'], 100)
        for q in all_queries['queries']:
            TestCase.assertIn(self, 'query_id', q)
            TestCase.assertIn(self, 'query_text', q)
            TestCase.assertIn(self, 'indicators', q)
            TestCase.assertGreater(self, len(q['indicators']), 0)

        # print_json(all_queries)

        total_pages = 3
        page_size = 5
        total_queries = total_pages * page_size

        print "Getting first " + str(total_queries) + " popular queries"
        all_queries = get_popular_queries_list(limit=total_queries)['queries']
        # print_json(all_queries)

        print "Testing popular queries paging..."
        self.do_test_paging(
            all_queries,
            lambda offset, limit: get_popular_queries_list(offset=offset, limit=limit)['queries'],
            total_pages,
            page_size
        )

    def test_query_history(self):
        print "Testing query history"
        print "Getting popular queries"
        all_queries = get_popular_queries_list(offset=0, limit=1)
        q = all_queries['queries'][0]
        query_id = q['query_id']

        print "Getting " + str(query_id) + " history"
        query_history = get_query_history(query_id, query_indicator=['TOTAL_SHOWS', 'TOTAL_CLICKS'])
        TestCase.assertIn(self, 'TOTAL_SHOWS', query_history)
        TestCase.assertIn(self, 'TOTAL_CLICKS', query_history)
        TestCase.assertEqual(self, 32, len(query_history['TOTAL_SHOWS']))
        TestCase.assertEqual(self, 32, len(query_history['TOTAL_CLICKS']))

        print "Testing getting query history for date range..."
        self.do_test_date_range_filter(
            query_history['TOTAL_SHOWS'],
            lambda date_from, date_to:
            get_query_history(query_id, date_from=date_from, date_to=date_to, query_indicator='TOTAL_SHOWS')['TOTAL_SHOWS']
        )

    def test_all_queries_history(self):
        print "Testing all queries history"
        query_history = get_all_queries_history(query_indicator=['TOTAL_SHOWS', 'TOTAL_CLICKS'])
        TestCase.assertIn(self, 'TOTAL_SHOWS', query_history)
        TestCase.assertIn(self, 'TOTAL_CLICKS', query_history)
        TestCase.assertEqual(self, 32, len(query_history['TOTAL_SHOWS']))
        TestCase.assertEqual(self, 32, len(query_history['TOTAL_CLICKS']))

        print "Testing getting query history for date range..."
        self.do_test_date_range_filter(
            query_history['TOTAL_SHOWS'],
            lambda date_from, date_to:
            get_all_queries_history(date_from=date_from, date_to=date_to, query_indicator='TOTAL_SHOWS')['TOTAL_SHOWS']
        )


if __name__ == "__main__":
    unittest.main()
