from base import *

USER_ID = get_user_id()
print "API user id: " + str(USER_ID)

HOST = 'http://www.bloknotov.ru'
HOST_ID = url_to_host_id(HOST)
print "Using host: " + HOST_ID

SEARCH_URLS_HISTORY_PATH = "/user/{user_id}/hosts/{host_id}/search-urls/in-search/history/".format(user_id=USER_ID, host_id=HOST_ID)
SEARCH_URLS_SAMPLES_PATH = "/user/{user_id}/hosts/{host_id}/search-urls/in-search/samples/".format(user_id=USER_ID, host_id=HOST_ID)
SEARCH_URLS_EVENTS_HISTORY_PATH = "/user/{user_id}/hosts/{host_id}/search-urls/events/history/".format(user_id=USER_ID, host_id=HOST_ID)
SEARCH_URLS_EVENTS_SAMPLES_PATH = "/user/{user_id}/hosts/{host_id}/search-urls/events/samples/".format(user_id=USER_ID, host_id=HOST_ID)


def test_date_range_filter(all_data, data_getter):
    all_data_slice = all_data[1:-2]
    date_from = all_data_slice[0]['date']
    date_to = all_data_slice[-1]['date']
    filtered_data = data_getter(date_from=date_from, date_to=date_to)
    assert filtered_data == all_data_slice


def test_paging(all_data, data_getter, total_pages, page_size):
    for offset in range(0, total_pages * page_size, page_size):
        pages_data = data_getter(offset=offset, limit=page_size)
        ref_pages_data = all_data[offset:offset + page_size]
        assert pages_data == ref_pages_data


def get_search_urls_history(date_from=None, date_to=None):
    r = SESSION.get(API_URL + SEARCH_URLS_HISTORY_PATH, params={
        'date_from': date_from,
        'date_to': date_to,
    })
    c = validate_api_response(r, ['history'])

    return c['history']


def get_search_urls_events_history(date_from=None, date_to=None):
    r = SESSION.get(API_URL + SEARCH_URLS_EVENTS_HISTORY_PATH, params={
        'date_from': date_from,
        'date_to': date_to,
    })
    c = validate_api_response(r, ['indicators'])

    return c['indicators']


def get_search_urls_samples(offset=0, limit=100):
    r = SESSION.get(API_URL + SEARCH_URLS_SAMPLES_PATH, params={
        'offset': offset,
        'limit': limit
    })
    c = validate_api_response(r, ['count', 'samples'])

    return c


def get_search_urls_events_samples(offset=0, limit=100):
    r = SESSION.get(API_URL + SEARCH_URLS_EVENTS_SAMPLES_PATH, params={
        'offset': offset,
        'limit': limit
    })
    c = validate_api_response(r, ['count', 'samples'])

    return c


def run():
    print "Getting search urls history: "
    all_history = get_search_urls_history()
    print_json(all_history)

    print "Testing getting search urls history for date range..."
    test_date_range_filter(
        all_history,
        lambda date_from, date_to: get_search_urls_history(date_from=date_from, date_to=date_to)
    )
    print "Ok"

    total_pages = 3
    page_size = 5
    total_samples = total_pages * page_size

    print "Getting first " + str(total_samples) + " search urls samples:"
    all_samples = get_search_urls_samples(limit=total_samples)['samples']
    print_json(all_samples)

    print "Testing search urls samples paging..."
    test_paging(
        all_samples,
        lambda offset, limit: get_search_urls_samples(offset=offset, limit=limit)['samples'],
        total_pages,
        page_size
    )
    print "Ok"

    print "Getting search urls events history: "
    all_events_history = get_search_urls_events_history()
    print_json(all_events_history)
    test_date_range_filter(
        all_events_history['APPEARED_IN_SEARCH'],
        lambda date_from, date_to: get_search_urls_events_history(date_from=date_from, date_to=date_to)['APPEARED_IN_SEARCH']
    )

    print "Getting first " + str(total_samples) + " search urls events samples:"
    all_samples = get_search_urls_events_samples(limit=total_samples)['samples']
    print_json(all_samples)

    print "Test search urls events samples paging..."
    test_paging(
        all_samples,
        lambda offset, limit: get_search_urls_events_samples(offset=offset, limit=limit)['samples'],
        total_pages,
        page_size
    )
    print "Ok"


if __name__ == "__main__":
    run()
