# coding=utf-8
import csv

import requests
from yt.wrapper.client import Yt
from yt.wrapper.ypath import TablePath

YT_TABLE_SCHEMA = [
    {'name': 'user_id', 'type': 'uint64'},
    {'name': 'login', 'type': 'string'},
    {'name': 'total_reqs', 'type': 'uint64'}
]

BB_URL = 'https://blackbox.yandex.net/blackbox'


def run():
    yt_rows = []
    active_users = read_csv()
    cnt = 0
    for active_user in active_users:
        if cnt % 500 == 0:
            print "Processed: " + str(cnt)
        cnt += 1
        bb_info = get_bb_info(active_user['user_id'])
        login = bb_info['users'][0]['login']
        yt_row = {
            'user_id': active_user['user_id'],
            'login': login,
            'total_reqs': active_user['total_reqs']
        }

        yt_rows.append(yt_row)

    write_yt_table(yt_rows, '//home/webmaster/users/leonidrom/xml/xml-active-users')


def read_csv():
    active_users = []
    with open('/tmp/xml_active_users.csv') as csv_file:
        csv_reader = csv.reader(csv_file, delimiter='\t')
        for row in csv_reader:
            user_id = int(row[0])
            total_reqs = int(row[1])
            active_users.append({
                'user_id': user_id,
                'total_reqs': total_reqs
            })

    return active_users


def get_bb_info(user_id):
    params = {
        'userip': '127.0.0.1',
        'method': 'userinfo',
        'format': 'json',
        'uid': user_id
    }

    r = requests.get(url=BB_URL, params=params)
    data = r.json()

    return data


def get_yt_token():
    from environs import Env
    env = Env()
    yt_token = env('YT_TOKEN', None)
    if yt_token:
        return yt_token

    from os.path import expanduser
    home_path = expanduser("~")

    try:
        with open(home_path + '/' + '.yt/token') as f:
            l = list(f)
            if l:
                return l[0].strip()
    except:
        return None


def write_yt_table(rows, table_name):
    yt_client = Yt(proxy='arnold.yt.yandex.net', token=get_yt_token())
    tp = TablePath(table_name, schema=YT_TABLE_SCHEMA, append=False)
    yt_client.write_table(tp, rows, raw=False, force_create=True)


run()



