package ru.yandex.webmaster3.storage;

/**
 * @author aherman
 */
public class WebmasterSQLException extends Exception {
    private final String dbIdentity;

    public WebmasterSQLException(String dbIdentity, String message) {
        super(createMessage(dbIdentity, message));
        this.dbIdentity = dbIdentity;
    }

    public WebmasterSQLException(String dbIdentity, String message, Throwable cause) {
        super(createMessage(dbIdentity, message), cause);
        this.dbIdentity = dbIdentity;
    }

    public WebmasterSQLException(String dbIdentity, Throwable cause) {
        super(createMessage(dbIdentity, ""), cause);
        this.dbIdentity = dbIdentity;
    }

    public static class ReadOnly extends WebmasterSQLException {
        public ReadOnly(String dbIdentity, String message) {
            super(dbIdentity, message);
        }

        public ReadOnly(String dbIdentity, String message, Throwable cause) {
            super(dbIdentity, message, cause);
        }

        public ReadOnly(String dbIdentity, Throwable cause) {
            super(dbIdentity, cause);
        }

    }

    private static String createMessage(String identity, String message) {
        return "In DB " + identity + ": " + message;
    }

}
