package ru.yandex.webmaster3.storage;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;

/**
 * @author avhaliullin
 */
public abstract class WebmasterStorageException extends RuntimeException {
    public WebmasterStorageException(String message) {
        super(message);
    }

    public WebmasterStorageException(String message, Throwable cause) {
        super(message, cause);
    }

    public WebmasterStorageException(Throwable cause) {
        super(cause);
    }

    public WebmasterException asUnchecked(String msg, Class cls) {
        return new WebmasterException(msg, errorResponse(cls), this);
    }

    public WebmasterException asUnchecked() {
        return new WebmasterException("", errorResponse(null), this);
    }

    protected abstract WebmasterErrorResponse errorResponse(Class cls);
}
