package ru.yandex.webmaster3.storage.abt.hash;

import lombok.Value;

/**
 * Created by Oleg Bazdyrev on 15/08/2018.
 */
@Value
public class HashExperimentRecord {
    private final String experiment;
    private final String group;
    private final HashField hashField;
    private final HashFunction hashFunction;
    private final double minValue;
    private final double maxValue;


    public boolean isSuitableFor(Object object) {
        double hash = hashFunction.hash(hashField.getHashObject(object));
        return hash >= minValue && hash < maxValue;
    }

    public boolean isForAll() {
        return minValue <= 0.0d && maxValue >= 1.0d;
    }
}
