package ru.yandex.webmaster3.storage.abt.hash;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.WwwUtil;

/**
 * Created by Oleg Bazdyrev on 15/08/2018.
 */
public enum HashField {
    USER_ID,
    HOST_ID,
    DOMAIN_WITHOUT_WWW {
        @Override
        public Object getHashObject(Object object) {
            if (object instanceof WebmasterHostId) {
                return WwwUtil.cutWww(((WebmasterHostId) object).getPunycodeHostname());
            }
            return object;
        }
    };

    public Object getHashObject(Object object) {
        return object;
    }
}
