package ru.yandex.webmaster3.storage.abt.hash;

import ru.yandex.webmaster3.core.util.FNVHash;

import java.math.BigDecimal;
import java.math.MathContext;

/**
 * Created by Oleg Bazdyrev on 15/08/2018.
 */
public enum HashFunction {
    FNV64_MOD {
        @Override
        public double hash(Object object) {
            return FNVHash.hash64Mod(object.toString(), 100) / 100.0;
        }
    },
    // TODO больше для совместимости с данными из yql
    FNV64_DIV {
        @Override
        public double hash(Object object) {
            long hash = FNVHash.hash64(object.toString());
            BigDecimal value = BigDecimal.valueOf(Math.abs(hash));
            if (hash < 0) {
                value = MAX_LONG_FIX.subtract(value);
            }
            return value.divide(MAX_LONG, MathContext.DECIMAL64).doubleValue();
        }
    },;

    private static BigDecimal MAX_LONG = BigDecimal.valueOf(2L).pow(64).subtract(BigDecimal.ONE);
    private static BigDecimal MAX_LONG_FIX = BigDecimal.valueOf(2L).pow(64);

    public abstract double hash(Object object);
}
