package ru.yandex.webmaster3.storage.abt.model;

import java.util.Optional;

import lombok.NonNull;
import lombok.SneakyThrows;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author akhazhoyan 06/2018
 */
public enum Experiment implements IExperiment {
    @Description("Костыльный эксперимент, чтобы не падать на новых неизвестных")
    UNKNOWN(ExperimentScope.USER),
    TEST_USER_FIRST(ExperimentScope.USER),
    TEST_USER_SECOND(ExperimentScope.USER),
    TEST_HOST_FIRST(ExperimentScope.HOST),
    TEST_HOST_SECOND(ExperimentScope.HOST),
    TEST_DOMAIN_FIRST(ExperimentScope.DOMAIN),
    @Description("Конкуренты с чатами")
    CHAT_RIVALS(ExperimentScope.HOST),
    @Description("Доступность оплат")
    TURBO_PAYMENTS_VISIBLE(ExperimentScope.HOST),
    @Description("WMC-6971: Обход урлов по счетчикам метрики по новой схеме")
    METRIKA_COUNTERS_CRAWL(ExperimentScope.HOST),
    @Description("WMC-7516: popup по автопарсеру")
    TURBO_AUTOPARSER_POPUP(ExperimentScope.DOMAIN),
    @Description("WMC-7408: тизер по Турбо для интернет-магазинов")
    TURBO_YML_TEASER(ExperimentScope.DOMAIN),
    @Description("WMC-7433: Добавить опции доставки в Турбо-настройки")
    TURBO_DELIVERY_OPTIONS(ExperimentScope.HOST),
    @Description("WMC-7431: В Турбо добавить комментарии от комментатора")
    TURBO_CMNT_COMMENTS(ExperimentScope.HOST),
    @Description("Тизер для интернет-магазинов по Турбо")
    TURBO_SHOP_TEASER(ExperimentScope.DOMAIN),
    @Description("Тизер турбо по скорости группа 1")
    DASHBOARD_TURBO_SPEED(ExperimentScope.DOMAIN),
    @Description("WMC-7947")
    TURBO_OPTIONS_HEADER_COLOR(ExperimentScope.USER),
    @Description("WMC-7947")
    TURBO_OPTIONS_ADV_BACKGROUND(ExperimentScope.USER),
    @Description("Новые фичи внешнего API")
    EXTERNAL_API_NEW_FEATURES(ExperimentScope.USER),
    @Description("Addurl через Самовар")
    URL_RECRAWL_SAMOVAR(ExperimentScope.HOST),
    @Description("Авто добавление важных урлов WMC-8004")
    AUTO_ADD_IMPORTANT_URLS(ExperimentScope.HOST),
    @Description("Notification experiment")
    REVIEW_NOTIFICATION(ExperimentScope.USER),
    @Description("Тизер для недоподключившихся к турбо магазинов с yml фидами WMC-8236")
    TURBO_TEASER_FOR_STORE_WITH_YML(ExperimentScope.DOMAIN),
    @Description("Тизер для недоподключившихся к турбо не магазинов с rss фидами WMC-8236")
    TURBO_TEASER_FOR_NO_STORE_WITH_RSS(ExperimentScope.DOMAIN),
    @Description("Турбо: автоменю для екоммерс (WMC-8284)")
    TURBO_AUTO_MENU(ExperimentScope.HOST),
    @Description("Эксперементы с уведомления через SUP")
    SUP_NOTIFICATION_SUBSCRIPTION(ExperimentScope.USER),
    @Description("Эксперимент для Post welcome письма")
    POST_WELCOME_EMAIL(ExperimentScope.HOST),
    @Description("Проверка хостовой мобилопригодности через Самовар")
    HOST_MOBILE_AUDIT_SAMOVAR(ExperimentScope.HOST),
    @Description("WMC-8490: Отправлять письма о том, что удалим неподтвержденный сайт")
    UNVERIFIED_HOST_REMOVAL(ExperimentScope.USER),
    @Description("Грейд скорости на странице качества")
    SPEED_GRADE_ACHIEVEMENT(ExperimentScope.USER),
    @Description("У хоста по нашему классификатору используется CMS Bitrix")
    CMS_BITRIX(ExperimentScope.HOST),
    @Description("WMC-9061: [Бэк] Алерт (рекомендация) подключить крупные фавиконки или svg")
    TURBO_ABOUT_SHOP(ExperimentScope.USER),
    TURBO_SPLIT(ExperimentScope.USER),
    DIGEST_LITE_FIRST_MESSAGE(ExperimentScope.USER),
    IKS_UPDATE_EMAIL(ExperimentScope.HOST),
    @Description("WMC-9724: Cделать эксп без валидации рекламы")
    TURBO_DISABLE_ADS_VALIDATION(ExperimentScope.DOMAIN),
    @Description("WMC-9799: Модерация скк для ecom.")
    TURBO_SCC_MODERATION(ExperimentScope.DOMAIN),
    @Description("Эксперемент для рекламы из коробки который они скоро раскатят на всех.")
    PI_MEDIA_IN_DESIGNS_FEATURES(ExperimentScope.USER),
    @Description("Эксперемент для рассылки уведомлений об икс конкурентов.")
    SQL_RIVAL_NOTIFICATION(ExperimentScope.USER),
    @Description("WMC-10163: Добавить рассылку по СКК при смене статусов")
    SCC_NOTIFICATIONS(ExperimentScope.DOMAIN),
    @Description("WMC-10127: [Бэк] Добавить способы оплаты в вебмастер")
    TURBO_NEW_PAYMENTS_METHODS(ExperimentScope.DOMAIN),
    @Description("Переробход сайтмепов через ")
    SITEMAP_RECRAWL_SAMOVAR(ExperimentScope.HOST),
    @Description("Отключаем Скк и вешаем плашку")
    SHOP_SCC_OFF(ExperimentScope.DOMAIN),
    @Description("WMC-10525. Свежесть")
    SEARCH_URL_FRESH(ExperimentScope.USER),
    SEARCH_URL_FRESH_GROUPING(ExperimentScope.HOST),
    @Description("Удаление с поиска через Самовар")
    DELURL_SAMOVAR(ExperimentScope.HOST),
    REPEATED_NOTIFICATIONS(ExperimentScope.HOST),
    TURN_OFF_COMMENTATOR(ExperimentScope.HOST),
    HOSTS_WITH_DISABLED_COMMENTATOR(ExperimentScope.DOMAIN),
    URL_ALERT_5XX(ExperimentScope.HOST),
    URL_ALERT_4XX(ExperimentScope.HOST),
    NO_404_ERRORS_ALERT(ExperimentScope.HOST),
    NO_MAIN_MIRROR(ExperimentScope.USER),
    SURVEY_USER_STATES(ExperimentScope.USER),
    FEEDS_NOTIFICATIONS(ExperimentScope.DOMAIN),
    @Description("WMC-11589: Поддержка MimeType для sitemap")
    SITEMAP_INVALID_MIMETYPE(ExperimentScope.HOST),
    FEEDS_DASHBOADR_CACHE(ExperimentScope.USER),
    ;

    private final ExperimentScope scope;

    Experiment(ExperimentScope scope) {
        this.scope = scope;
    }

    public static final EnumResolver<Experiment> R = EnumResolver.er(Experiment.class);

    @Override
    public ExperimentScope getScope() {
        return scope;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @SneakyThrows
    @NonNull
    @Override
    public String getDescription() {
        final Optional<Description> descriptionOpt =
                Optional.ofNullable(Experiment.class.getField(getName()).getAnnotation(Description.class));
        return descriptionOpt.map(Description::value).orElse("");
    }
}
