package ru.yandex.webmaster3.storage.abt.model;

import java.util.Objects;
import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.joda.time.DateTime;

/**
 * ishalaru
 * 12.11.2019
 **/

public class ExperimentInfo {
    public final String experiment;
    public final String group;

    @Nullable
    public final DateTime updateDate;

    public ExperimentInfo(String experiment, String group) {
        this(experiment, group, null);
    }

    @JsonCreator
    public ExperimentInfo(@JsonProperty("experiment") String experiment,
                          @JsonProperty("group") String group,
                          @JsonProperty("updateDate") @Nullable DateTime updateDate) {
        this.experiment = Optional.of(experiment).orElse(Experiment.UNKNOWN.getName());
        this.group = Preconditions.checkNotNull(group);
        this.updateDate = updateDate;
    }

    public String getExperiment() {
        return experiment;
    }

    public String getGroup() {
        return group;
    }

    @Nullable
    public DateTime getUpdateDate() {
        return updateDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExperimentInfo that = (ExperimentInfo) o;
        return Objects.equals(experiment, that.experiment) && group.equals(that.group);
    }

    @Override
    public int hashCode() {
        int result = experiment.hashCode();
        result = 31 * result + group.hashCode();
        return result;
    }
}
