package ru.yandex.webmaster3.storage.achievements.model;

import lombok.ToString;

import ru.yandex.webmaster3.core.util.json.polymorphic.Polymorphic;

/**
 * Created by Oleg Bazdyrev on 17/01/2019.
 */
@ToString
public abstract class AchievementProblem implements Polymorphic<AchievementProblemType> {

    private final AchievementProblemType type;

    protected AchievementProblem(AchievementProblemType type) {
        this.type = type;
    }

    @Override
    public AchievementProblemType getType() {
        return type;
    }

    public static final class LicenseRevokedProblem extends AchievementProblem {

        public LicenseRevokedProblem() {
            super(AchievementProblemType.LICENSE_REVOKED);
        }

    }

    public static final class UnsafeHostProblem extends AchievementProblem {

        public UnsafeHostProblem() {
            super(AchievementProblemType.UNSAFE_HOST);
        }
    }
}
