package ru.yandex.webmaster3.storage.achievements.model;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;
import ru.yandex.webmaster3.core.util.json.polymorphic.Polymorphic;

/**
 * Created by Oleg Bazdyrev on 17/01/2019.
 */
public enum AchievementProblemType implements Discriminator<Polymorphic<AchievementProblemType>> {
    @Description("Лицензия кредитной организации аннулирована")
    LICENSE_REVOKED(AchievementProblem.LicenseRevokedProblem.class),
    @Description("На сайте обнаружены проблемы с безопасностью")
    UNSAFE_HOST(AchievementProblem.UnsafeHostProblem.class),
    ;

    private final Class<? extends AchievementProblem> dataClass;

    AchievementProblemType(Class<? extends AchievementProblem> dataClass) {
        this.dataClass = dataClass;
    }

    @Override
    public Class<? extends AchievementProblem> getDataClass() {
        return dataClass;
    }
}