package ru.yandex.webmaster3.storage.achievements.model;

import com.google.common.base.Enums;
import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by Oleg Bazdyrev on 06/11/2018.
 */
@Description("Страны для ачивок")
public enum AchievementTld {

    RU(true),
    COM(false),
    BY(false),
    KZ(false),
    UA(false),
    UZ(false),
    ;

    private final boolean canHaveTld;

    AchievementTld(boolean canHaveTld) {
        this.canHaveTld = canHaveTld;
    }

    public boolean isCanHaveTld() {
        return canHaveTld;
    }

    public static AchievementTld getIfPresent(String name) {
        return Enums.getIfPresent(AchievementTld.class, name).orNull();
    }
}
