package ru.yandex.webmaster3.storage.achievements.model;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;

import java.util.EnumSet;

/**
 * Created by Oleg Bazdyrev on 24/08/2018.
 */
public enum AchievementType implements Discriminator<AchievementInfo> {
    @Description("ИКС")
    IKS(AchievementInfo.Iks.class, AchievementValueType.NUMERIC),
    @Description("Не совсем ачивка, но все же")
    SQI(AchievementInfo.SqiAchievementInfo.class, AchievementValueType.SQI, EnumSet.of(AchievementTld.RU)),
    @Description("Рейтинг товарной вертикали")
    VERTICAL_SHARE_RATING(AchievementInfo.VerticalShareRatingInfo.class, AchievementValueType.NUMERIC, EnumSet.of(AchievementTld.RU)),
    @Description("Проверенность магазина товарной вертикали")
    VERTICAL_SHARE_IS_VALIDATED(AchievementInfo.VerticalShareIsValidatedInfo.class, AchievementValueType.BOOLEAN, EnumSet.of(AchievementTld.RU)),
    @Description("Официальность")
    OFFICIAL(AchievementInfo.OfficialAchievementInfo.class, AchievementValueType.OFFICIAL),
    @Description("Не совсем ачивка, но все же")
    MARKET_RATING(AchievementInfo.MarketRatingInfo.class, AchievementValueType.NUMERIC, EnumSet.of(AchievementTld.RU)),
    @Description("Скорость сайта")
    MOBILE_SPEED(AchievementInfo.MobileSpeedAchievementInfo.class, AchievementValueType.NUMERIC),
    @Description("Количество страниц в поиске")
    DOCS_ON_SEARCH(AchievementInfo.DocsOnSearch.class, AchievementValueType.NUMERIC),
    @Description("бОльшая доля траффика приходит на https")
    HTTPS(AchievementInfo.HttpsAchievementInfo.class, AchievementValueType.BOOLEAN),
    @Description("Выбор пользователей")
    USER_CHOICE(AchievementInfo.UserChoiceAchievementInfo.class, AchievementValueType.NUMERIC),
    @Description("Популярный")
    POPULAR(AchievementInfo.PopularAchievementInfo.class, AchievementValueType.NUMERIC),
    @Description("TAS-IX - TAShkent Internet eXchange")
    TAS_IX(AchievementInfo.TasIxAchievementInfo.class, AchievementValueType.BOOLEAN, EnumSet.of(AchievementTld.UZ)),
    @Description("Videohosting's rating")
    VIDEOHOST_RATING(AchievementInfo.VideohostRatingInfo.class, AchievementValueType.NUMERIC),
    @Description("Турбо")
    TURBO(AchievementInfo.TurboAchievementInfo.class, AchievementValueType.BOOLEAN),
    ;

    private final Class<? extends AchievementInfo> dataClass;
    private final AchievementValueType valueType;
    private final EnumSet<AchievementTld> possibleTlds;

    AchievementType(Class<? extends AchievementInfo> dataClass, AchievementValueType valueType) {
        this(dataClass, valueType, EnumSet.allOf(AchievementTld.class));
    }

    AchievementType(Class<? extends AchievementInfo> dataClass, AchievementValueType valueType,
                    EnumSet<AchievementTld> possibleTlds) {
        this.dataClass = dataClass;
        this.valueType = valueType;
        this.possibleTlds = possibleTlds;
    }

    @Override
    public Class<? extends AchievementInfo> getDataClass() {
        return dataClass;
    }

    public AchievementValueType getValueType() {
        return valueType;
    }

    public EnumSet<AchievementTld> getPossibleTlds() {
        return possibleTlds;
    }
}
