package ru.yandex.webmaster3.storage.achievements.model.official;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;

/**
 * Created by Oleg Bazdyrev on 11/09/2018.
 */
public enum AchievementOfficialType implements Discriminator<OfficialInfo> {

    @Description("Сайт принадлежит организации, имеющий статус официального дилера на сервисе Auto.ru")
    AUTO(OfficialInfo.AutoRuDealerInfo.class),
    @Description("Сайт организации внесен в Государственный реестр микрофинансовых организаций ЦБ РФ")
    MFO(OfficialInfo.MicroFinanceInfo.class),
    @Description("Сайт организации внесен в Реестр субъектов страхового дела")
    SSD(OfficialInfo.InsuranceInfo.class),
    //@Description("Сайт официального визового центра")
    //VISA(4, null),
    @Description("Официальный государственный сайт")
    GOV(OfficialInfo.GovermentInfo.class),
    @Description("Сервис Яндекс")
    YANDEX(OfficialInfo.YandexServiceInfo.class),
    @Description("Кредитная организация из каталога ЦБ РФ")
    CREDIT_ORGANIZATION(OfficialInfo.CreditOrganizationInfo.class),
    @Description("Официальный сервисный центр")
    SERVICE_CENTER(OfficialInfo.ServiceCenterInfo.class),
    @Description("Авиакомпания")
    AIRLINE(OfficialInfo.AirlineInfo.class),
    @Description("Посольство")
    EMBASSY(OfficialInfo.EmbassyInfo.class),
    @Description("Официальный визовый центр")
    VISA_CENTER(OfficialInfo.VisaCenterInfo.class),
    @Description("Официальный бренд")
    BRAND(OfficialInfo.BrandInfo.class),
    @Description("Сайт организации занесен в единый реестр/список профессиональных участников рынка ценных бумаг")
    CBRF_PROF(OfficialInfo.CbrfProfInfo.class),
    @Description("Сайт организации занесен в реестр лицензий бирж и торговых систем")
    CBRF_STOCK(OfficialInfo.CbrfStockInfo.class),
    @Description("Сайт организации занесен в список адресов web-сайтов кредитных организаций и список профессиональных участников рынка ценных бумаг")
    CBRF_KOPURCB(OfficialInfo.CbrfKopurcbInfo.class),
    @Description("Официальное бюро кредитных историй")
    CBRF_BKI(OfficialInfo.CbrfBkiInfo.class),
    @Description("Сайт организации, сведения о котором внесены в реестр лицензий негосударственных пенсионных фондов")
    CBRF_NPF(OfficialInfo.CbrfNpfInfo.class),
    @Description("Оффициальный сайт театра, занесенный в список сайтов театральных площадок и коллективов Мин. Культуры РФ")
    THEATRE(OfficialInfo.TheatreInfo.class),
    ;

    private final Class<? extends OfficialInfo> dataClass;

    AchievementOfficialType(Class<? extends OfficialInfo> dataClass) {
        this.dataClass = dataClass;
    }

    @Override
    public Class<? extends OfficialInfo> getDataClass() {
        return dataClass;
    }
}
