package ru.yandex.webmaster3.storage.achievements.model.official;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.json.polymorphic.Polymorphic;

/**
 * Created by Oleg Bazdyrev on 30/01/2019.
 */
public abstract class OfficialInfo implements Polymorphic<AchievementOfficialType> {

    private final AchievementOfficialType type;

    protected OfficialInfo(AchievementOfficialType type) {
        this.type = type;
    }

    @Override
    public AchievementOfficialType getType() {
        return type;
    }

    public static final class AutoRuDealerInfo extends OfficialInfo {

        public AutoRuDealerInfo() {
            super(AchievementOfficialType.AUTO);
        }
    }

    public static final class MicroFinanceInfo extends OfficialInfo {

        public MicroFinanceInfo() {
            super(AchievementOfficialType.MFO);
        }
    }

    public static final class InsuranceInfo extends OfficialInfo {

        public InsuranceInfo() {
            super(AchievementOfficialType.SSD);
        }
    }

    public static final class GovermentInfo extends OfficialInfo {

        public GovermentInfo() {
            super(AchievementOfficialType.GOV);
        }
    }

    public static final class YandexServiceInfo extends OfficialInfo {

        public YandexServiceInfo() {
            super(AchievementOfficialType.YANDEX);
        }
    }

    public static final class CreditOrganizationInfo extends OfficialInfo {

        public CreditOrganizationInfo() {
            super(AchievementOfficialType.CREDIT_ORGANIZATION);
        }
    }

    public static final class ServiceCenterInfo extends OfficialInfo {

        private final String brand;

        public ServiceCenterInfo(String brand) {
            super(AchievementOfficialType.SERVICE_CENTER);
            this.brand = brand;
        }

        @Description("Бренд официального сервисаного центра")
        public String getBrand() {
            return brand;
        }
    }

    public static final class AirlineInfo extends OfficialInfo {

        public AirlineInfo() {
            super(AchievementOfficialType.AIRLINE);
        }
    }

    public static final class EmbassyInfo extends OfficialInfo {

        public EmbassyInfo() {
            super(AchievementOfficialType.EMBASSY);
        }
    }

    public static final class VisaCenterInfo extends OfficialInfo {

        public VisaCenterInfo() {
            super(AchievementOfficialType.VISA_CENTER);
        }
    }

    public static final class BrandInfo extends OfficialInfo {

        private final String brand;

        public BrandInfo(String brand) {
            super(AchievementOfficialType.BRAND);
            this.brand = brand;
        }

        public String getBrand() {
            return brand;
        }
    }

    public static final class CbrfProfInfo extends OfficialInfo {

        public CbrfProfInfo() {
            super(AchievementOfficialType.CBRF_PROF);
        }
    }

    public static final class CbrfStockInfo extends OfficialInfo {

        public CbrfStockInfo() {
            super(AchievementOfficialType.CBRF_STOCK);
        }
    }

    public static final class CbrfKopurcbInfo extends OfficialInfo {

        public CbrfKopurcbInfo() {
            super(AchievementOfficialType.CBRF_KOPURCB);
        }
    }

    public static final class CbrfNpfInfo extends OfficialInfo {

        public CbrfNpfInfo() {
            super(AchievementOfficialType.CBRF_NPF);
        }
    }

    public static final class TheatreInfo extends OfficialInfo {

        public TheatreInfo() {
            super(AchievementOfficialType.THEATRE);
        }
    }

    public static final class CbrfBkiInfo extends OfficialInfo {

        public CbrfBkiInfo() {
            super(AchievementOfficialType.CBRF_BKI);
        }
    }


}
