package ru.yandex.webmaster3.storage.addurl;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.storage.iks.IksService;

/**
 * Created by ifilippov5 on 02.11.17.
 */
@Service
@AllArgsConstructor(onConstructor_ = @Autowired)
public class AddUrlLimitsService {
    public static final int DEFAULT_LIMIT = 30;
    private static final Map<String, Integer> SPECIAL_OWNERS = ImmutableMap.<String, Integer>builder()
            .put("yandex.ru", 1000)
            .put("yandex.com", 1000)
            .put("yandex.by", 1000)
            .put("yandex.ua", 1000)
            .put("yandex.kz", 1000)
            // TODO temp
            .put("thevoicemag.ru", 200)
            .put("novochag.ru", 200)
            .put("techinsider.ru", 200)
            .put("mentoday.ru", 200)
            .put("thesymbol.ru", 200)
            .put("pravilamag.ru", 200)
            .build();

    private final IksService iksService;

    public int getActualLimit(String owner) {
        int limit = SPECIAL_OWNERS.getOrDefault(owner, 0);
        if (limit == 0) {
            int iks = iksService.getIksValueForOwner(owner);

            if (iks <= 10) {
                limit = DEFAULT_LIMIT;
            } else {
                limit = (int) (Math.log(iks - 5.0) * 35.0);
                limit -= limit % 10; //округляем вниз до десятков
            }
        }

        return limit;
    }
}
