package ru.yandex.webmaster3.storage.admin;

import ru.yandex.webmaster3.core.blackbox.UserWithLogin;

/**
 * @author avhaliullin
 */
public class AdminUserInfo {
    private final UserWithLogin adminUser;
    private final UserWithLogin passportUser;

    public AdminUserInfo(UserWithLogin adminUser, UserWithLogin passportUser) {
        this.adminUser = adminUser;
        this.passportUser = passportUser;
    }

    public UserWithLogin getAdminUser() {
        return adminUser;
    }

    public UserWithLogin getPassportUser() {
        return passportUser;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AdminUserInfo that = (AdminUserInfo) o;

        if (!adminUser.equals(that.adminUser)) return false;
        return passportUser.equals(that.passportUser);

    }

    @Override
    public int hashCode() {
        int result = adminUser.hashCode();
        result = 31 * result + passportUser.hashCode();
        return result;
    }
}
