package ru.yandex.webmaster3.storage.admin.security;

import org.jetbrains.annotations.NotNull;

/**
 * @author avhaliullin
 */
public class Permission {
    private final AccessActionEnum action;
    private final AccessObjectEnum accessObject;

    public Permission(@NotNull AccessActionEnum action, @NotNull AccessObjectEnum accessObject) {
        this.action = action;
        this.accessObject = accessObject;
    }

    public AccessActionEnum getAction() {
        return action;
    }

    public AccessObjectEnum getAccessObject() {
        return accessObject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Permission that = (Permission) o;

        if (accessObject != that.accessObject) return false;
        if (action != that.action) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = action.hashCode();
        result = 31 * result + accessObject.hashCode();
        return result;
    }

}
