package ru.yandex.webmaster3.storage.admin.security;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

import static ru.yandex.webmaster3.storage.admin.security.AccessObjectEnum.*;
import static ru.yandex.webmaster3.storage.admin.security.PermissionsSet.allActionsFor;
import static ru.yandex.webmaster3.storage.admin.security.PermissionsSet.readFor;

/**
 * @author avhaliullin
 */
public enum Role {
    SUPPORT("Support",
            allActionsFor(VIRUAL_LOGIN, HOST_SELF_VERIFICATION, TOOLS, SPAM_BAN)
                    .with(readFor(USERS_HOSTS))
                    .with(readFor(SANCTIONS))
                    .with(readFor(MIRRORS))),

    SUPER_SUPPORT("SuperSupport",
            allActionsFor(VIRUAL_LOGIN, HOST_REGION_MODERATION, DISPLAY_NAME_MODERATION, HOST_SELF_VERIFICATION, TOOLS, SPAM_BAN)
                    .with(readFor(USERS_HOSTS))
                    .with(readFor(SANCTIONS))
                    .with(readFor(MIRRORS))),

    MODERATOR("Moderator",
            allActionsFor(HOST_REGION_MODERATION, DISPLAY_NAME_MODERATION, TOOLS)
                    .with(readFor(SPAM_BAN))),

    MANAGER("Manager",
            allActionsFor(VIRUAL_LOGIN, HOST_SELF_VERIFICATION)
                    .with(readFor(USERS_HOSTS))
                    .with(readFor(SPAM_BAN))),
    NOTIFICATIONS_ADMIN("NotificationsAdmin", allActionsFor(NOTIFICATIONS)),
    DEVELOPER("Developer", PermissionsSet.everythingExcept(NOTIFICATIONS).with(readFor(NOTIFICATIONS))),
    ;

    private final String description;
    private final PermissionsSet permissions;

    Role(String description, PermissionsSet permissions) {
        this.description = description;
        this.permissions = permissions;
    }

    public String getDescription() {
        return description;
    }

    public String getId() {
        return name().toLowerCase();
    }

    public PermissionsSet getPermissions() {
        return permissions;
    }

    public static Role fromId(String id) {
        return id == null ? null : valueOf(id.toUpperCase());
    }

    public static final EnumResolver<Role> R = EnumResolver.er(Role.class);
}
