package ru.yandex.webmaster3.storage.antispam.threats.dao;

import java.util.function.Consumer;

import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

@Repository
public class HostThreatForceRecheckQueueYDao extends AbstractYDao {
    private static final String TABLE_NAME = "host_threat_force_recheck_queue";

    @Autowired
    public HostThreatForceRecheckQueueYDao() {
        super(PREFIX_CHECKLIST, TABLE_NAME);
    }

    public void insertHost(WebmasterHostId hostId) {
        execute(insert(
                F.HOST_ID.value(hostId),
                F.ADD_DATE.value(DateTime.now())
        ));
    }

    public void forEachHost(Consumer<WebmasterHostId> consumer) {
        queryForList(select(F.HOST_ID), DataMapper.create(F.HOST_ID, a -> a)).forEach(consumer);
    }

    private static class F {
        static final Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
        static final Field<DateTime> ADD_DATE = Fields.jodaDateTimeField("add_date");
    }
}
