package ru.yandex.webmaster3.storage.antispam.threats.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.autodoc.common.doc.annotation.Description;

import java.util.List;

public class HostVerdictInfo {
    private final String verdict;
    private final List<VerdictUrlSample> verdictUrlSamples;

    @JsonCreator
    public HostVerdictInfo(String verdict, List<VerdictUrlSample> verdictUrlSamples) {
        this.verdict = verdict;
        this.verdictUrlSamples = verdictUrlSamples;
    }

    @Description("Название вердикта")
    public String getVerdict() {
        return verdict;
    }

    @Description("Примеры зараженных урлов")
    public List<VerdictUrlSample> getVerdictUrlSamples() {
        return verdictUrlSamples;
    }
}
