package ru.yandex.webmaster3.storage.antispam.threats.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author avhaliullin
 */
public class ThreatsRecheckRequest {
    private final WebmasterHostId hostId;
    private final DateTime recheckDate;
    private final Set<String> threats;

    public ThreatsRecheckRequest(WebmasterHostId hostId, DateTime recheckDate, List<String> threats) {
        this(hostId, recheckDate, new HashSet<>(threats));
    }

    public ThreatsRecheckRequest(WebmasterHostId hostId, DateTime recheckDate, Set<String> threats) {
        this.hostId = hostId;
        this.recheckDate = recheckDate;
        this.threats = threats;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public DateTime getRecheckDate() {
        return recheckDate;
    }

    public Set<String> getThreats() {
        return threats;
    }
}
