package ru.yandex.webmaster3.storage.antispam.threats.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;

import java.util.List;

public class VerdictUrlSample {
    private final String url;
    private final DateTime lastChecked;
    private final List<String> infectionChain;

    @JsonCreator
    public VerdictUrlSample(String url, DateTime lastChecked, List<String> infectionChain) {
        this.url = url;
        this.lastChecked = lastChecked;
        this.infectionChain = infectionChain;
    }

    public String getUrl() {
        return url;
    }

    @Description("Дата последней проверки урла")
    public DateTime getLastChecked() {
        return lastChecked;
    }

    @Description("Цепочка заражения (может отсутствовать)")
    public List<String> getInfectionChain() {
        return infectionChain;
    }
}
