package ru.yandex.webmaster3.storage.async.model;

import org.joda.time.DateTime;

import java.util.UUID;

/**
 * Pojo object for working with async operation.
 */
public class AsyncOperationRequestInfo {
    private final UUID requestId;
    private final DateTime lastUpdate;
    private final AsyncTaskType asyncTaskType;
    private final int version;
    private final String requestData;
    private final HttpAsyncRequestInfoRequestState state;
    private final HttpAsyncRequestInfoResultType result;
    private final int responseObjectTypeId;
    private final String response;

    public AsyncOperationRequestInfo(
            UUID requestId,
            DateTime lastUpdate,
            AsyncTaskType asyncTaskType, int version, String requestData, HttpAsyncRequestInfoRequestState state,
            HttpAsyncRequestInfoResultType result, int responseObjectTypeId, String response) {
        this.requestId = requestId;
        this.lastUpdate = lastUpdate;
        this.asyncTaskType = asyncTaskType;
        this.version = version;
        this.requestData = requestData;
        this.state = state;
        this.result = result;
        this.responseObjectTypeId = responseObjectTypeId;
        this.response = response;
    }

    public UUID getRequestId() {
        return requestId;
    }

    public DateTime getLastUpdate() {
        return lastUpdate;
    }

    public AsyncTaskType getAsyncTaskType() {
        return asyncTaskType;
    }

    public int getVersion() {
        return version;
    }

    public String getRequestData() {
        return requestData;
    }

    public HttpAsyncRequestInfoRequestState getState() {
        return state;
    }

    public HttpAsyncRequestInfoResultType getResult() {
        return result;
    }

    public String getResponse() {
        return response;
    }

    public int getResponseObjectTypeId() {
        return responseObjectTypeId;
    }
}
