package ru.yandex.webmaster3.storage.async.model;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author: ishalaru
 * DATE: 14.05.2019
 * Типы поддерживаемых асинхронных операций.
 */
public enum AsyncTaskType implements IntEnum {
    ANALYZE_SITEMAP_ACTION(0),
    ANALYZE_ROBOT_TXT(1),
    SERVER_ANSWER(2),
    ADD_FEED(3),
    ROTOR_CHECK(4),
    URL_CHECK(5),
    ;

    private final int value;

    AsyncTaskType(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<AsyncTaskType> R = IntEnumResolver.r(AsyncTaskType.class);

}
