package ru.yandex.webmaster3.storage.async.model;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Available task state
 */
public enum HttpAsyncRequestInfoRequestState implements IntEnum {
    NEW(0),
    TASK_STARTED(1),
    TASK_FINISHED(2);

    private final int value;

    HttpAsyncRequestInfoRequestState(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<HttpAsyncRequestInfoRequestState> R = IntEnumResolver.r(HttpAsyncRequestInfoRequestState.class);
}

