package ru.yandex.webmaster3.storage.async.model;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Available result state of async operation
 */
public enum HttpAsyncRequestInfoResultType implements IntEnum {
    OK(0),
    INTERNAL_ERROR(1),
    FETCH_FAILED(2);
    private final int value;

    HttpAsyncRequestInfoResultType(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<HttpAsyncRequestInfoResultType> R = IntEnumResolver.r(HttpAsyncRequestInfoResultType.class);
}
