package ru.yandex.webmaster3.storage.avatars;

import java.util.List;

import lombok.Builder;
import lombok.Value;

/**
 * Created by ifilippov5 on 24.07.17.
 */
@Value
@Builder
public class UploadPictureResult {

    boolean isSvg;
    List<AvatarPicture> pictures;
    InvalidPictureErrorCode invalidPictureErrorCode;
    Integer width;
    Integer height;

    public enum InvalidPictureErrorCode {
        IMAGE_IS_TOO_SMALL(0),
        UNABLE_TO_DOWNLOAD_IMAGE_BY_URL(1);

        private int code;

        InvalidPictureErrorCode(int code) {
            this.code = code;
        }
    }
}
