package ru.yandex.webmaster3.storage.cache;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum DashboardType implements IntEnum {
    UNKNOWN(0),

    SEARCH_QUERY_GROUP_HISTORY(1),
    SEARCH_QUERY_LIST_TOP(2),
    SEARCH_QUERY_LIST_FAVORITE(3),
    SEARCH_URL_SAMPLES(4),
    LINK_EXTERNAL_SAMPLES(5),
    SEARCH_URL_HISTORY(6),
    // TCI больше нет, оставленно для истории
    // INDEXING_TCI_HISTORY(7),
    INDEXING_HISTORY(8),
    INDEXING_URLS_COUNT_HISTORY(9),
    INDEXING_EVENT_SAMPLES_HISTORY(10),
    TURBO(11),
    INDEXING_IKS_HISTORY(12),
    FEEDS(13),
    ;

    private final int value;

    DashboardType(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<DashboardType> R = IntEnumResolver.r(DashboardType.class);
}
