package ru.yandex.webmaster3.storage.cache.dao;

import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.geoadv.GeoAdvertisingInfo;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;


@Slf4j
@Repository
public class GeoAdvCacheYDao extends AbstractYDao {

    private static final String TABLE_NAME = "geoadv_api_response";

    @Autowired
    public GeoAdvCacheYDao() {
        super(PREFIX_CACHE, TABLE_NAME);
    }

    public void add(WebmasterHostId hostId, GeoAdvertisingInfo geoAdvertisingInfo) {
        execute(
                upsert(
                        F.HOST_ID.value(hostId),
                        F.VALUE.value(geoAdvertisingInfo),
                        F.ADD_DATE.value(DateTime.now())
                )
        );
    }

    @Nullable
    public GeoAdvertisingInfo get(WebmasterHostId hostId)  {
        return queryOne(select(F.VALUE).where(F.HOST_ID.eq(hostId)).getStatement(), VALUE_MAPPER);
    }

    private static final DataMapper<GeoAdvertisingInfo> VALUE_MAPPER = DataMapper.create(F.VALUE, r -> r);

    private static class F {
        private static final Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
        private static final Field<GeoAdvertisingInfo> VALUE = Fields.jsonField("value", GeoAdvertisingInfo.class);
        private static final Field<DateTime> ADD_DATE = Fields.jodaDateTimeField("add_date");
    }
}
