package ru.yandex.webmaster3.storage.checklist.dao;

import java.util.EnumMap;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;

/**
 * @author avhaliullin
 */
public enum ChecklistSamplesType implements IntEnum {
    EMPTY_TITLE(0, SiteProblemTypeEnum.DOCUMENTS_MISSING_TITLE),
    EMPTY_DESC(1, SiteProblemTypeEnum.DOCUMENTS_MISSING_DESCRIPTION),
    NOT_MOBILE_FRIENDLY(2, SiteProblemTypeEnum.NOT_MOBILE_FRIENDLY),
    @Deprecated // move to SLOW_RESPONSE_WITH_EXAMPLES
    SLOW_RESPONSE(3, SiteProblemTypeEnum.SLOW_AVG_RESPONSE),
    YABROWSER_BADAD(4, SiteProblemTypeEnum.YABROWSER_BADAD),
    TURBO_FEED_BAN(5, SiteProblemTypeEnum.TURBO_FEED_BAN),
    TURBO_DOCUMENT_BAN(6, SiteProblemTypeEnum.TURBO_DOCUMENT_BAN),
    TURBO_HOST_BAN(7, SiteProblemTypeEnum.TURBO_HOST_BAN),
    TURBO_INSUFFICIENT_CLICKS_SHARE(8, SiteProblemTypeEnum.TURBO_INSUFFICIENT_CLICKS_SHARE),
    FAVICON_ERROR(9, SiteProblemTypeEnum.FAVICON_ERROR),
    TURBO_LISTING_ERROR(10, SiteProblemTypeEnum.TURBO_LISTING_ERROR),
    TURBO_URL_ERRORS(11, SiteProblemTypeEnum.TURBO_URL_ERRORS),
    SLOW_RESPONSE_WITH_EXAMPLES(12, SiteProblemTypeEnum.SLOW_AVG_RESPONSE_WITH_EXAMPLES),

    METRIKA_CRAWL_LOST_HITS_SAMPLES_FOR_NO_METRIKA_COUNTER_BINDING(13, SiteProblemTypeEnum.NO_METRIKA_COUNTER_BINDING),
    METRIKA_CRAWL_LOST_HITS_SAMPLES_FOR_NO_METRIKA_COUNTER_CRAWL_ENABLED(14, SiteProblemTypeEnum.NO_METRIKA_COUNTER_CRAWL_ENABLED),
    TURBO_HOST_BAN_INFO(15, SiteProblemTypeEnum.TURBO_HOST_BAN_INFO),
    URL_ALERT_5XX(16, SiteProblemTypeEnum.URL_ALERT_5XX),
    URL_ALERT_4XX(17, SiteProblemTypeEnum.URL_ALERT_4XX),
    DISALLOWED_URLS_ALERT(18, SiteProblemTypeEnum.DISALLOWED_URLS_ALERT),
    ;

    private static final EnumMap<SiteProblemTypeEnum, ChecklistSamplesType> samplesTypeByProblemType =
            new EnumMap<>(SiteProblemTypeEnum.class);
    static {
        for (ChecklistSamplesType samplesType : values()) {
            if (samplesType.problemType != null) {
                samplesTypeByProblemType.put(samplesType.problemType, samplesType);
            }
        }
    }

    private final int value;
    private final SiteProblemTypeEnum problemType;

    ChecklistSamplesType(int value, SiteProblemTypeEnum problemType) {
        this.value = value;
        this.problemType = problemType;
    }

    @Override
    public int value() {
        return value;
    }

    public SiteProblemTypeEnum getProblemType() {
        return problemType;
    }

    public static ChecklistSamplesType byProblemType(SiteProblemTypeEnum problemType) {
        return samplesTypeByProblemType.get(problemType);
    }

    public static final IntEnumResolver<ChecklistSamplesType> R = IntEnumResolver.r(ChecklistSamplesType.class);
}
