package ru.yandex.webmaster3.storage.checklist.dao;

import java.util.stream.Stream;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.RowMapper;


/**
 * @author akhazhoyan 10/2018
 */
@Repository
class NewDomainsNotificationTablesYDao extends AbstractYDao {

    public NewDomainsNotificationTablesYDao() {
        super(PREFIX_INTERNAL, "new_domains_notifications_tables");
    }

    public Stream<Pair<String, Boolean>> load() {
        return select(F.MAPPER).queryForList().stream();
    }

    public Pair<String, Boolean> select(String tableId) {
        return select(F.MAPPER).where(F.TABLE_ID.eq(tableId)).queryOne();
    }

    public void upsert(String tableId, boolean isProcessed) {
        upsert(F.TABLE_ID.value(tableId), F.IS_PROCESSED.value(isProcessed))
                .execute();
    }

    public boolean recordExists(String tableId) {
        return select(F.TABLE_ID)
                .where(F.TABLE_ID.eq(tableId))
                .limit(1)
                .queryForList()
                .size() > 0;
    }

    private interface F {
        Field<String> TABLE_ID = Fields.stringField("table_id");
        Field<Boolean> IS_PROCESSED = Fields.boolField("is_processed");

        RowMapper<Pair<String, Boolean>> MAPPER = DataMapper.create(TABLE_ID, IS_PROCESSED, Pair::of);
    }
}
