package ru.yandex.webmaster3.storage.checklist.dao;

import com.datastax.driver.core.utils.UUIDs;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import java.util.UUID;

/**
 * @author akhazhoyan 10/2018
 */
public final class NewDomainsNotificationUtil {

    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormat.forPattern("yyyyMMdd_HHmmss");

    private static DateTime tableIdToDate(String chTableId) {
        return DateTime.parse(chTableId, TIME_FORMATTER);
    }

    public static UUID tableIdToUuid(String chTableId) {
        return UUIDs.startOf(tableIdToDate(chTableId).getMillis());
    }

    public static String uuidToTableId(UUID tableUuid) {
        return TIME_FORMATTER.print(UUIDs.unixTimestamp(tableUuid));
    }
}
