package ru.yandex.webmaster3.storage.checklist.dao;

import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;

import com.datastax.driver.core.utils.UUIDs;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * Created by Oleg Bazdyrev on 19/11/2018.
 */
@Repository
public class TurboHostBanRecheckQueueYDao extends AbstractYDao {

    private static final DataMapper<RecheckRecord> MAPPER = DataMapper.create(
            F.ID, F.HOST_ID, F.DATE, RecheckRecord::new);

    public TurboHostBanRecheckQueueYDao() {
        super(PREFIX_TURBO, "turbo_host_ban_recheck_queue");
    }

    public void addRecord(WebmasterHostId hostId) {
        insert(F.ID.value(UUIDs.timeBased()),
                F.HOST_ID.value(hostId),
                F.DATE.value(DateTime.now()))
                .execute();
    }

    public void deleteRecords(Collection<UUID> ids) {

        delete().where(F.ID.in(ids)).execute();
    }

    public void forEach(Consumer<RecheckRecord> consumer) {
        streamReader(MAPPER, consumer);
    }

    private interface F {
        Field<UUID> ID = Fields.uuidField("id");
        Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
        Field<DateTime> DATE = Fields.jodaDateTimeField("date");
    }

    public static final class RecheckRecord {

        private final UUID id;
        private final WebmasterHostId hostId;
        private final DateTime date;

        public RecheckRecord(UUID id, WebmasterHostId hostId, DateTime date) {
            this.id = id;
            this.hostId = hostId;
            this.date = date;
        }

        public UUID getId() {
            return id;
        }

        public WebmasterHostId getHostId() {
            return hostId;
        }

        public DateTime getDate() {
            return date;
        }
    }
}
