package ru.yandex.webmaster3.storage.checklist.dao;

import java.util.UUID;
import java.util.function.Consumer;

import com.datastax.driver.core.utils.UUIDs;
import lombok.Value;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * Created by Oleg Bazdyrev on 19/11/2018.
 */
@Repository
public class TurboInvalidCartUrlRecheckQueueYDao extends AbstractYDao {

    private static final DataMapper<RecheckRecord> MAPPER = DataMapper.create(
            F.ID, F.DOMAIN, F.DATE, RecheckRecord::new);

    public TurboInvalidCartUrlRecheckQueueYDao() {
        super(PREFIX_TURBO, "turbo_invalid_cart_url_recheck_queue");
    }

    public void addRecord(String domain) {
        upsert(F.ID.value(UUIDs.timeBased()),
                F.DOMAIN.value(domain),
                F.DATE.value(DateTime.now()))
                .execute();
    }

    public void forEach(Consumer<RecheckRecord> consumer) {
        streamReader(MAPPER, consumer);
    }

    private interface F {
        Field<UUID> ID = Fields.uuidField("id");
        Field<String> DOMAIN = Fields.stringField("domain");
        Field<DateTime> DATE = Fields.jodaDateTimeField("date");
    }

    @Value
    public static final class RecheckRecord {
        UUID id;
        String domain;
        DateTime date;
    }
}
