package ru.yandex.webmaster3.storage.checklist.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class CleanableProblem {
    private final SiteProblemTypeEnum problemType;
    private final DateTime lastUpdate;
    private final WebmasterHostId hostId;

    public CleanableProblem(SiteProblemTypeEnum problemType, DateTime lastUpdate, WebmasterHostId hostId) {
        this.problemType = problemType;
        this.lastUpdate = lastUpdate;
        this.hostId = hostId;
    }

    public SiteProblemTypeEnum getProblemType() {
        return problemType;
    }

    public DateTime getLastUpdate() {
        return lastUpdate;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }
}
