package ru.yandex.webmaster3.storage.checklist.data;

import org.joda.time.DateTime;

/**
 * @author avhaliullin
 */
public class ExtendedProblem<T extends ProblemSignal> {
    private final T problem;
    private final int weight;
    private final boolean recheckRequested;
    private final DateTime recheckRequestDate;
    private final boolean recheckFailed;

    public ExtendedProblem(T problem, int weight, boolean recheckRequested, DateTime recheckRequestDate, boolean recheckFailed) {
        this.problem = problem;
        this.weight = weight;
        this.recheckRequested = recheckRequested;
        this.recheckRequestDate = recheckRequestDate;
        this.recheckFailed = recheckFailed;
    }

    public T getProblem() {
        return problem;
    }

    public int getWeight() {
        return weight;
    }

    public boolean isRecheckRequested() {
        return recheckRequested;
    }

    public DateTime getRecheckRequestDate() {
        return recheckRequestDate;
    }

    public boolean isRecheckFailed() {
        return recheckFailed;
    }
}
