package ru.yandex.webmaster3.storage.checklist.data;

import lombok.ToString;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemState;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemStorageType;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;

/**
 * @author avhaliullin
 */
@ToString
public class ProblemStateInfo {
    private final SiteProblemTypeEnum problemType;
    private final SiteProblemState state;

    public ProblemStateInfo(SiteProblemTypeEnum problemType, SiteProblemState state) {
        this.problemType = problemType;
        this.state = state;
    }

    public SiteProblemTypeEnum getProblemType() {
        return problemType;
    }

    public SiteProblemState getState() {
        return state;
    }

    public boolean isGenerationBased() {
        return problemType.getStorageType() == SiteProblemStorageType.GENERATION_BASED;
    }

    public boolean isTurbo() {
        return problemType.isTurboProblem();
    }

    public boolean isNonTurbo() {
        return !problemType.isTurboProblem();
    }
}
