package ru.yandex.webmaster3.storage.checklist.data;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemState;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * Created by ifilippov5 on 10.09.17.
 */
public class RawSiteProblem {
    private final WebmasterHostId hostId;
    private final SiteProblemTypeEnum problemType;
    private final SiteProblemState state;
    private UUID generationId;

    public RawSiteProblem(WebmasterHostId hostId, SiteProblemTypeEnum problemType, SiteProblemState state) {
        this.hostId = hostId;
        this.problemType = problemType;
        this.state = state;
    }

    public RawSiteProblem(WebmasterHostId hostId, SiteProblemTypeEnum problemType, SiteProblemState state, UUID generationId) {
        this.hostId = hostId;
        this.problemType = problemType;
        this.state = state;
        this.generationId = generationId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public SiteProblemTypeEnum getProblemType() {
        return problemType;
    }

    public SiteProblemState getState() {
        return state;
    }

    public UUID getGenerationId() {
        return generationId;
    }
}
