package ru.yandex.webmaster3.storage.checklist.data;

import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemContent;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemState;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class RawSiteProblemInfo extends ProblemSignal {
    private final WebmasterHostId hostId;
    private final UUID generationId;

    public RawSiteProblemInfo(WebmasterHostId hostId, UUID generationId, DateTime date, @Nullable SiteProblemContent content,
                              SiteProblemState state, SiteProblemTypeEnum problemType) {
        super(content, problemType, state, date);
        this.hostId = hostId;
        this.generationId = generationId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public UUID getGenerationId() {
        return generationId;
    }

    public static RawSiteProblemInfo create(SiteProblemContent content, WebmasterHostId hostId, UUID generationId,
                                            DateTime date) {
        return new RawSiteProblemInfo(hostId, generationId, date, content, SiteProblemState.PRESENT, content.getProblemType());
    }
}
